import React, {Component} from 'react';
import PropTypes from 'prop-types';
import Select from "../Select/Select";
import {graphql, compose} from "react-apollo";
import {limpidezzasQuery} from "../../../../api/queries";
import {Card, CardBody, CardText} from "reactstrap";
import BlinkDot from "../../../Loading/BlinkDot";

class LimpidezzaSelect extends Component {

    constructor(props) {
        super(props);
    }

    render() {
        if(this.props.data.loading) {
            return(<Card>
                <CardBody>
                    <CardText className="text-info">
                        Caricamento in corso{' '}
                        <BlinkDot/>
                        <BlinkDot/>
                        <BlinkDot/>
                    </CardText>
                </CardBody>
            </Card>);
        }

        return (<Select
            {...this.props}
            options={this.props.data.limpidezzas.map(item => {
                return { value: item.id, label: item.etichetta, };
            })} />);
    }
}

export default compose(
    graphql(limpidezzasQuery),
)(LimpidezzaSelect)

LimpidezzaSelect.defaultProps = {};

LimpidezzaSelect.propTypes = {};